 using System; 
 using System.Collections.Generic; 
 using System.ComponentModel; using System.Data; 
 using System.Drawing; 
 using System.Linq; 
 using System.Text; using System.Windows.Forms; 
 using PsgBase;

namespace Template2
{
    [EditorClass, ViewGrid]
    public partial class Template2 : BaseDetails
    {
        #region GlobalVariables

        Template2BE.Template2DataTable table = new Template2BE.Template2DataTable();
        Template2BE.Template2Row rowA = null;

        #endregion

        #region Constructors

        public Template2()
        {
            InitializeComponent();
        }

        public Template2(ViewGrid _view)
            : base(_view)
        {
            InitializeComponent();
        }

        public Template2(LookupGrid _lookup)
            : base(_lookup)
        {
            InitializeComponent();
        }

        #endregion

        public override void PsgContext(IContext context)
        {
            base.PsgContext(context);
            context.PsgFieldKey = "id";
            context.PsgFieldDisplay = "column1";
            context.PsgCommand = "template2";
            context.PsgServerTableName = "template2";

        }

        public override void PsgStart()
        {
            base.PsgStart();
            AddTable("template2", ID);
            AddTable("template2d", ID);
            GetTables(this);

        }

        public override void PsgData(DataTable dt)
        {
            base.PsgData(table);
            switch (this.alias_name.ToUpper())
            {
                case "TEMPLATE2":
                    table = (Template2BE.Template2DataTable)SetMainData(dt, table);
                    rowA = (Template2BE.Template2Row)table.Rows[0];
                    break;

                case "TEMPLATE2D":
                    tableDServer = this.Intf.PsgTableServer;
                    gridDetails.DataSource = tableDServer;
                    break;
            }

        }

        public override void PsgBind()
        {
            BindEdit(edcol1, table.column1Column);
            BindData(dtcol2, table.column2Column);
            BindChecked(chkcol3, table.column3Column);
            base.PsgBind();
        }

        public override void PsgView()
        {
            base.PsgView();
            this.ColumnsView(table.column1Column, "Column1");
            this.ColumnsView(table.column2Column, "Column2");

            this.FiltersView(table.column1Column, "Column1");
            this.FiltersView(table.column2Column, "Column2");

        }

        public override void PsgLookup()
        {
            base.PsgLookup();
            this.ColumnsLookup(table.column1Column, "Column1");
            this.ColumnsLookup(table.column2Column, "Column2");

            this.FiltersLookup(table.column1Column, "Column1");
            this.FiltersLookup(table.column2Column, "Column2");

        }
    }
}